﻿var BUTTON_TAB_BLANK_HEIGHT = 69;
var id;
var actionType;

var psiIdSection;

var MENU_TABLE_INFO = 0;
var MENU_DESC = 5;

var operation;
var OPER_APPLY = 1;
var OPER_TABLE = 2;
var OPER_PROG = 3;
var OPER_ELEMENT = 4;
var OPER_STREAM = 5;
var OPER_FIRST_DESC = 6;
var OPER_SECOND_DESC = 7;

var elementType;
var VIDEO = 0;
var AUDIO = 1;

var nodeIndex;
var posIndex;
var parentIndex;
var descTag = 0;
var descId;
var curMenuId = null;

var PSI_NUM = 8;//共8种表，包括PAT、PMT、SDTA、SDTO、NITA、NITO 8种
var psiType;
var newPsiId;
var newPsiIdString = [];
var idString;
var breadCrumbText;

//page Type
var PAT = 45;
var PMT = 46;
var SDTA = 47;
var SDTO = 48;
var NITA = 49;
var NITO = 50;
var BAT = 51;
var CAT = 52;
var psiNodes = ["PAT", "PMT", "SDTA", "SDTO", "NITA", "NITO", "BAT", "CAT"];

var CHECKED = 1;
var NO_CHECKED = 0;

var CUSTOM = 17;
var CUSTOM_LINK_TYPE = 9;

var descData = [];
var rowNum = 0;

var DESC_NUM = 35;
var descTypeArray = [2, 3, 5, 6, 9, 10, 11, 12, 14, 15, 16, 64, 65, 66, 67, 68, 71, 72, 73, 74, 82, 83, 86, 87, 89, 90, 91, 92, 93, 95, 98, 100, 106, 122, 131];
var descPage = ["video_stream_desc", "audio_stream_desc", "regist_desc", "data_stream_align_desc", "ca_desc", 
				"ISO_639_desc", "sys_clock_desc", "multi_buffer_desc", "max_bitrate_desc", "private_indicate_desc", "smooth_buffer_desc",
				"net_name_desc", "service_list_desc", "stuff_desc", "satellite_delivery_desc", "cable_delivery_desc", "bouquet_name_desc",
				"service_desc", "available_country_desc", "link_desc", "stream_identifier_desc", "ca_identifier_desc", "teletext_desc",
				"telephone_desc", "subtitle_desc", "terrestrial_desc", "multi_net_name_desc", "multi_bouq_name_desc", "multi_serv_name_desc",
				"private_data_desc", "freq_list_desc", "data_broadcast_desc", "ac3_desc", "ac3_desc", "lcn_desc"];

var zTree;
var setting = 
{
	editable: false,//参数设置为true便可使用拖拽功能
	edit_renameBtn: false,
	edit_removeBtn: false,
	dragCopy: true,
	dragMove: false,
	data: {
		key: {
			children: "nodes"
		},
		simpleData: {
			enable: false,
			idKey: "id",
			pIdKey: "pId",
			rootPId: null
		}
	},
	view: {
		showLine: true,
		showTitle:false,
		showIcon:false,
		selectedMulti: false
	},
	callback:{
		onRightClick: zTreeRightClick,
		onExpand: zTreeOnExpand
	}
};

var serviceCustomFlag = false;  // tag = 72
var serviceListCustomFlag = false;  //tag = 65;
var linkTypeCustomFlag = false;  //tag = 74;
	
window.onresize = function()
{
	$("#treeContent").css("height", function(index, value)
	{
		return (($("#mainContent").height() - BUTTON_TAB_BLANK_HEIGHT) + "px");
	});
}

$(document).ready(function()
{
	if(curMenuId != null)
	{
		hideRightMenu(curMenuId);
	}
	document.body.onclick = function()
	{
		if(curMenuId != null)
		{
			hideRightMenu(curMenuId);
		}
	}
	document.oncontextmenu = function()
	{
		if(curMenuId != null)
		{
			hideRightMenu(curMenuId);
		}
	}
	$("#descApplyBtn, #descCancelBtn, #addBtn").live("mouseover", function()
	{
		inButtonClassChange($(this).attr("class"), $(this).attr("id"));
	});
	$("#descApplyBtn, #descCancelBtn, #addBtn").live("mouseout", function()
	{
		outButtonClassChange($(this).attr("class"), $(this).attr("id"));
	});
	
	$("#treeContent").css("height", function(index, value)
	{
		return (($("#mainContent").height() - BUTTON_TAB_BLANK_HEIGHT) + "px");
	});	
	
	var group;
	var userName;
	var mainIpAddr;
	var args = GetArgs();
	id = args["psiId"];
	idString = id.split("_");
	group = args["group"];
	userName = args["userName"];
	mainIpAddr = args["mainIpAddr"];
	breadCrumbText = encodeURIComponent("Table", "utf-8");
	$("#transferFrame").attr("src", "http://" + mainIpAddr + "/asp/transfer.asp?group=" + group + "&userName=" + userName +"&information=" + breadCrumbText);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{	
	DisableButton("applyBtn");	
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	reloadTree();
	
	
	//if(parent.groupAccess != USER)
	//{
		EnableButton("applyBtn");
	//}
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

/*************************************************
Function: 		reloadTree
Description: 	树的初始化
Input: 			无
Output:			无
Return: 		无
Others: 		无
*************************************************/
function reloadTree() 
{
	for(var i = 0; i < PSI_NUM ; i++)
	{
		if(psiType == i + PAT)
		{
			zTree = $.fn.zTree.init($("#treeDemo"),setting, eval(psiNodes[i] + "Nodes"));
		}
	}
	specialNodesInit();
}

function specialNodesInit()
{
	var treeObj;
	var allNodes;
	
	treeObj = $.fn.zTree.getZTreeObj("treeDemo");
	var allNodes = treeObj.transformToArray(treeObj.getNodes());
	for(var i = 0, len = allNodes.length; i < len; i++)
	{
		if(!allNodes[i].noR)
		{
			$("#" + allNodes[i].tId + "_span").css("font-weight", "bold");
		}
	}
}
/*************************************************
Function: 		zTreeOnExpand
Description: 	展开节点的回调函数，未展开的节点初始化的时候解析不到
Input: 			event:事件对象;
				treeId:当前树的treeId;
				treeNode:当前操作的树结点
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function zTreeOnExpand(event, treeId, treeNode)
{
	var treeObj;
	var allNodes;
	treeObj = $.fn.zTree.getZTreeObj("treeDemo");
	var allNodes = treeObj.transformToArray(treeNode.nodes);
	for(var i = 0, len = allNodes.length; i < len; i++)
	{
		if(!allNodes[i].noR)
		{
			$("#" + allNodes[i].tId + "_span").css("font-weight", "bold");
		}
	}
}

/*************************************************
Function: 		zTreeRightClick
Description: 	树的右键操作
Input: 			event:事件对象;
				treeId:当前树的treeId;
				treeNode:当前操作的树结点
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function zTreeRightClick(event, treeId, treeNode)
{
	var menuIndex;
	var descNodeId;
	var parentNode;
	
	if (!treeNode) 
	{
		zTree.cancelSelectedNode();			
		hideRightMenu();
	} 
	else if (treeNode && (!treeNode.noR)) 
	{
		/*
		if (event.target.tagName != "a" && $(event.target).parents("a").length == 0) 
		{			
			zTree.cancelSelectedNode();	
			hideRightMenu();
		}
		*/
		if(treeId == "treeDemo") 
		{
			zTree.selectNode(treeNode);
			nodeIndex = zTree.getNodeIndex(treeNode);
			menuIndex = treeNode.menuType;
			changeRightMenu(menuIdArray[menuIndex], event);
			switch(psiType)
			{
				case PAT:
					break;
				case PMT:
					if((menuIndex == MENU_ADD_PROG_DESC) || (menuIndex == MENU_VIDEO_ELEMENT) || (menuIndex == MENU_AUDIO_ELEMENT))//添加一级或二级描述符
					{
						descId = treeNode.ID;
						if(menuIndex == MENU_VIDEO_ELEMENT)
						{
							elementType = VIDEO;
						}
						else if(menuIndex == MENU_AUDIO_ELEMENT)
						{
							elementType = AUDIO;
						}
					}
					else if(menuIndex == MENU_DESC)
					{
						descTag = parseInt(treeNode.tag, 10);
						parentNode = treeNode.getParentNode();
						parentIndex = zTree.getNodeIndex(parentNode);
						descNodeId = parentNode.ID;
						posIndex = treeNode.pos;
						descId = descNodeId.concat("_", posIndex);
						if(treeNode.level == 2)
						{
							operation = OPER_FIRST_DESC;
						}
						else
						{
							operation = OPER_SECOND_DESC;
							if(parentNode.menuType == MENU_VIDEO_ELEMENT) //音频和视频下的数据流对准描述符是两个页面，但是对应的是一种描述符
							{
								elementType = VIDEO;
							}
							else
							{
								elementType = AUDIO;
							}
						}
					}
					break;
				case SDTA:
					if((menuIndex == MENU_PROG_DESC_BROAD) || (menuIndex == MENU_PROG_DESC_VOD))//添加二级描述符
					{
						descId = treeNode.ID;
					}
					else if(menuIndex == MENU_DESC)
					{
						operation = OPER_SECOND_DESC;
						descTag = parseInt(treeNode.tag, 10);
						parentNode = treeNode.getParentNode();
						parentIndex = zTree.getNodeIndex(parentNode);
						descNodeId = parentNode.ID;
						posIndex = treeNode.pos;
						descId = descNodeId.concat("_", posIndex);
					}
					break;
				case SDTO:				
					if(menuIndex == MENU_PROG)  //添加二级描述符
					{
						descId = treeNode.ID;
					}
					else if(menuIndex == MENU_DESC)  //Modify and delete descriptor
					{
						operation = OPER_SECOND_DESC;
						descTag = parseInt(treeNode.tag, 10);
						parentNode = treeNode.getParentNode();
						parentIndex = zTree.getNodeIndex(parentNode);
						descNodeId = parentNode.ID;
						posIndex = treeNode.pos;
						descId = descNodeId.concat("_", posIndex);
					}
					break;
				case CAT:
					if(menuIndex == MENU_ADD_CAT_DESC)  //Add CAT descriptor
					{
						descId = treeNode.ID;
					}
					else if(menuIndex == MENU_DESC)  //Modify and delete descriptor
					{
						operation = OPER_FIRST_DESC;
						descTag = parseInt(treeNode.tag, 10);
						descNodeId = treeNode.getParentNode().ID;
						posIndex = treeNode.pos;
						descId = descNodeId.concat("_", posIndex);
					}
					break;
				case BAT:
				case NITA:
				case NITO:
					if((menuIndex == MENU_ADD_FIRST_DESC) || (menuIndex == MENU_STREAM))//添加一级二级描述符
					{
						descId = treeNode.ID;
					}
					else if(menuIndex == MENU_DESC)  //Modify and delete descriptor
					{
						descTag = parseInt(treeNode.tag, 10);
						parentNode = treeNode.getParentNode();
						parentIndex = zTree.getNodeIndex(parentNode);
						descNodeId = parentNode.ID;
						posIndex = treeNode.pos;
						descId = descNodeId.concat("_", posIndex);
						if(treeNode.level == 2)  
						{
							operation = OPER_FIRST_DESC;
						}
						else  
						{
							operation = OPER_SECOND_DESC;
						}
					}
					break;
				default:
					break;					
			}
		}
	}
}

/*************************************************
Function: 		changeMenu
Description: 	改变右键菜单
Input: 			menuId:对应的菜单id;
				event:事件对象
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function changeRightMenu(menuId, event)
{
	var curBottomHeight;
	var curMenuHeight;
	if(curMenuId != null)
	{
		hideRightMenu(curMenuId);
	}
	//if(parent.groupAccess != USER)
	//{
		curBottomHeight = $(".tree_content").height() + 63 - event.clientY;
		curMenuHeight = $("#" + menuId).height();
		if (curBottomHeight  < curMenuHeight)
		{
			$("#" + menuId).css({"top": event.clientY - (curMenuHeight - curBottomHeight) + "px", "left": (event.clientX + 10) + "px", "display":""});
		}
		else
		{
			$("#" + menuId).css({"top": event.clientY + "px", "left": (event.clientX + 10) + "px", "display":""});
		}
	//}
	
	curMenuId = menuId;
}

/*************************************************
Function: 		hideRightMenu
Description: 	隐藏右键菜单
Input: 			menuId:对应的菜单id
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function hideRightMenu(menuId)
{
	$("#" + menuId).css("display", "none");
}
/*************************************************
Function: 		deleteDesc
Description: 	用于描述符的删除
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function deleteDesc()
{
	if(language == ENGLISH)
	{
		var confirmPrompt = "Are you sure to delete the descriptor?";
	}
	else
	{
		var confirmPrompt = "确定要删除当前描述符吗？";
	}
	if(window.confirm(confirmPrompt))
	{
		deleteApply();
	}
}

function deleteApply()
{
	var data;
	var index;
	var response;
	var xmlHttp = GetHTTPObject();
	
	data = "type=" + psiType + "&cmd=" + DELETE + "&language=" + language + "&id=" + id + "&operation=" + operation + "&descTag=" + descTag + "&setString=";
	if(operation == OPER_FIRST_DESC)
	{
		index = posIndex;
	}
	else if(operation == OPER_SECOND_DESC)
	{
		index = parentIndex + FIRST_DELIMITER + posIndex;
	}
	else
	{
		index = nodeIndex;
	}
	data += index;
	
	xmlHttp.open("POST", "/goform/formIPQAM", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(language == ENGLISH)
				{
					alert("Delete successfully!");
				}
				else
				{
					alert("删除成功！");
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			self.location.reload(true);
		}
	}
	xmlHttp.send(data);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	data = "type=" + psiType + "&cmd=" + SET + "&language=" + language + "&id=" + id + "&operation=" + OPER_APPLY 
	
	xmlHttp.open("POST", "/goform/formIPQAM", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				if(language == ENGLISH)
				{
					alert("Apply Successfully!");
				}
				else
				{
					alert("应用成功！");
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			if((psiType == NITO) || (psiType == NITA) || (psiType == SDTO) || (psiType == BAT))
			{
				var treeObj = zTree.getNodes();	
				var getNodesAttr = treeObj[0].nodes[0].psiId;
				psiIdSection = parseInt(getNodesAttr, 10);
				newPsIidString = [idString[0], idString[1], idString[2], idString[3], psiIdSection, idString[5]];
				newPsiId = newPsIidString.join("_");
				self.location.replace("?psiId=" + newPsiId + "");
			}
			else
			{
				self.location.reload(true);
			}
		}
	}
	xmlHttp.send(data);
}

/*************************************************
Function: 		cancelEdit
Description: 	弹出的编辑框取消编辑
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function cancelEdit()
{
	$.modal.close();
	descData = [];
	rowNum = 0;
	serviceCustomFlag = false;
	serviceListCustomFlag = false;
	linkTypeCustomFlag = false;
}

/*************************************************
Function: 		addDesc
Description: 	用于描述符的添加
Input: 			tag:描述符类型
				operation:操作类型0:add;1:modify
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function addDesc(tag, level)
{
	actionType = ADD;
	operation = level;
	descTag = tag;
	sendRequest();
}

/*************************************************
Function: 		modifyDesc
Description: 	用于描述符的修改
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function modifyDesc()
{
	actionType = SET;
	sendRequest();
}

/*************************************************
Function: 		sendRequest
Description: 	用于描述符页面的添加和修改
Input: 			无
Output: 		无
Return: 		无
Others: 		无
*************************************************/
function sendRequest()
{
	var descFlag = 0;
	$.ajaxSetup({cache:false});	
	for(var i = 0; i < DESC_NUM; i++)
	{
		if(descTag == descTypeArray[i])
		{
			$.get("desc/" + descPage[i] + pageLanguage[language], null, function (data, textStatus)
			{
				$("#descInfo").html(data);
				if(descTag == 6)
				{
					if(elementType == VIDEO)
					{
						$("#videoTable").css("display", "");
						$("#audioTable").css("display", "none");
					}
					else
					{
						$("#videoTable").css("display", "none");
						$("#audioTable").css("display", "");
					}
				}
				if(actionType == SET)
				{
					if((descTag == 106) || (descTag == 122))
					{
						$("#descEnhanced").attr("disabled", true);
					}
					getDescInfo();
				}
				else
				{
					if((descTag == 106) || (descTag == 122))
					{
						$("#descEnhanced").attr("disabled", false);
					}
					$("#descInfo").modal();	
				}
			});
			descFlag = 1;
		}
	}
	if(descFlag == 0)
	{
		$.get("desc/custom_desc" + pageLanguage[language], null, function (data, textStatus)
		{
			$("#descInfo").html(data);
			if(actionType == SET)
			{
				$("#customDescTag").attr("disabled", true);
				getDescInfo();
			}
			else
			{
				$("#customDescTag").attr("disabled", false);
				$("#descInfo").modal();	
			}
		});
	}
}

function getDescInfo()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	data = "type=" + psiType + "&cmd=" + GET + "&language=" + language + "&operation=" + operation + "&descId=" + descId + "&descTag=" + descTag;
	
	xmlHttp.open("POST", "/goform/formIPQAM", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			//if(response != "")
			//{
				data = response.split(FIRST_DELIMITER);
				displayDesc(data);
				$("#descInfo").modal();	
			//}
		}
	}
	xmlHttp.send(data);
}

function changeValue(obj)
{
	var height;
	switch(descTag)
	{
		case 2:
			if(obj.prop("checked") == true)
			{
				for(i = 5; i < OBJ_NUM; i++)
				{
					$("#" + objIdArray[i]).attr("disabled", false);
				}
			}
			else
			{
				for(i = 5; i < OBJ_NUM; i++)
				{
					$("#" + objIdArray[i]).attr("disabled", true);
				}
			}
			break;
		case 12:
			if(obj.prop("checked") == true)
			{
				$("#" + objIdArray[1]).attr("disabled", false);
			}
			else
			{
				$("#" + objIdArray[1]).attr("disabled", true);
			}
			break;
		case 65:
			if(obj.val() == CUSTOM)
			{
				$("#descCustomTypeTr").css("display", "");
				if(serviceListCustomFlag == false)
				{
					$("#simplemodal-container").css("height", function(index, value)
						{
							height = $(this).height();
							return ((height + ROW_HEIGHT) + "px");
						});
					serviceListCustomFlag = true;
				}
			}
			else
			{
				$("#descCustomTypeTr").css("display", "none");
				if(serviceListCustomFlag == true)
				{
					$("#simplemodal-container").css("height", function(index, value)
						{
							height = $(this).height();
							return ((height - ROW_HEIGHT) + "px");
						});
					serviceListCustomFlag = false;
				}
			}
		case 72:
			if(obj.val() == CUSTOM)
			{
				$("#descCustomTypeTr").css("display", "");
				if(serviceCustomFlag == false)
				{
					$("#simplemodal-container").css("height", function(index, value)
						{
							height = $(this).height();
							return ((height + ROW_HEIGHT) + "px");
						});
					serviceCustomFlag = true;
				}
			}
			else
			{
				$("#descCustomTypeTr").css("display", "none");
				if(serviceCustomFlag == true)
				{
					$("#simplemodal-container").css("height", function(index, value)
						{
							height = $(this).height();
							return ((height - ROW_HEIGHT) + "px");
						});
					serviceCustomFlag = false;
				}
			}
			break;
		case 74:
			if(obj.val() == CUSTOM_LINK_TYPE)
			{
				$("#descCustomTypeTr").css("display", "");
				if(linkTypeCustomFlag == false)
				{
					$("#simplemodal-container").css("height", function(index, value)
						{
							height = $(this).height();
							return ((height + ROW_HEIGHT) + "px");
						});
					linkTypeCustomFlag = true;
				}
			}
			else
			{
				$("#descCustomTypeTr").css("display", "none");
				if(linkTypeCustomFlag == true)
				{
					$("#simplemodal-container").css("height", function(index, value)
						{
							height = $(this).height();
							return ((height - ROW_HEIGHT) + "px");
						});
					linkTypeCustomFlag = false;
				}
			}
			break;
		default:
			break;
	}
}

function displayDesc(data)
{
	var i;
	var j;
	var length;
	var sectionData;
	
	switch(descTag)
	{
		case 2:
			for(i = 0; i < OBJ_NUM; i++)
			{
				if((i == 1) || (i == 5) || (i == 6) || (i == 7))
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
				else
				{
					if(parseInt(data[i], 10) == CHECKED)
					{
						$("#" + objIdArray[i]).prop("checked", true);
					}
					else
					{
						$("#" + objIdArray[i]).prop("checked", false);
					}
				}
			}
			changeValue($("#" + objIdArray[2]));
			break;
		case 3:
		case 11:
		case 12:
		case 87:
			for(i = 0; i < OBJ_NUM; i++)
			{
				if(i == 0)
				{
					if(parseInt(data[i], 10) == CHECKED)
					{
						$("#" + objIdArray[i]).prop("checked", true);
					}
					else
					{
						$("#" + objIdArray[i]).prop("checked", false);
					}
				}
				else
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
			}
			if(descTag == 12)
			{
				changeValue($("#" + objIdArray[0]));
			}
			break;
		case 6:
			$("#" + objIdArray[elementType]).val(data[0]);
			break;
		case 9:
		case 14:
		case 15:
		case 16:
		case 64:
		case 66:
		case 67:
		case 68:
		case 71:
		case 72:
		case 74:
		case 82:
		case 90:
		case 95:
		case 100:
			if(descTag != 74)
			{
				for(i = 0; i < OBJ_NUM; i++)
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
				if(descTag == 72)
				{
					if(parseInt($("#descServiceType").val(), 10) == CUSTOM)
					{
						$("#descCustomTypeTr").css("display", "");
						serviceCustomFlag = true;
					}
					else
					{
						$("#descCustomTypeTr").css("display", "none");
						serviceCustomFlag = false;
					}
				}
			}
			else
			{
				for(i = 0; i < OBJ_NUM; i++)
				{
					if(i != LINK_TYPE)
					{
						$("#" + objIdArray[i]).val(data[i]);
					}
					else
					{
						if(data[i] < 9)
						{
							$("#" + objIdArray[i]).val(data[i]);
							$("#descCustomTypeTr").css("display", "none");
							linkTypeCustomFlag = false;							
						}
						else
						{
							$("#" + objIdArray[i]).val(CUSTOM_LINK_TYPE);
							$("#descCustomType").val(data[i]);
							$("#descCustomTypeTr").css("display", "");
							linkTypeCustomFlag = true;
						}
					}
				}
			}
			break;
		case 65:
		case 83:
		case 86:
		case 89:
		case 91:
		case 92:
		case 93:
		case 131:
			rowNum = data.length;
			if(rowNum != 0)
			{
				for(i = 0; i < rowNum; i++)
				{
					descData.push(data[i]);
				}
				DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
				updateTableData();
			}
			break;
		case 10:
		case 73:
		case 98:
			$("#" + firstId).val(data[0]);
			if(data.length != 1)
			{
				descData = data[1].split(SECOND_DELIMITER);
				rowNum = descData.length;
				DrawTableRow("dataTable", "dataRow", "CaseRow", rowNum);
				for(var i = 0; i < rowNum; i++)
				{
					$("#" + objIdArray[0] + (i + 1)).html(descData[i]);
				}
				if((descTag == 98) && (rowNum != 0))
				{
					$("#codingType").attr("disabled", true);
				}
			}
			break;
		case 106:
			$("#descEnhanced").prop("checked", false);
			for(i = 0; i < SEC_NUM_NORMAL; i++)
			{
				sectionData = data[i].split(SECOND_DELIMITER);
				length = sectionData.length;
				for(j = 0; j < length; j++)
				{
					if((i == 0) && ((j == (length - 1)) || (j == (length - 2))))
					{
						$("#" + normalObjIdArray[i][j]).val(sectionData[j]);
					}
					else if((i == (SEC_NUM_NORMAL - 1)) && (j == 0))
					{
						$("#" + normalObjIdArray[i][j]).val(sectionData[j]);
					}
					else if((i == 2) && (j != 0))
					{
						$("#" + normalObjIdArray[i][j]).val(sectionData[j]);
					}
					else
					{
						if(parseInt(sectionData[j], 10) == CHECKED)
						{
							$("#" + normalObjIdArray[i][j]).prop("checked", true);
						}
						else
						{
							$("#" + normalObjIdArray[i][j]).prop("checked", false);
						}
						if((i == 2) && (j == 0))
						{
							changeFullService($("#fullService0"), 0);
						}
					}
				}
			}
			
			changeEnhance($("#descEnhanced"));
			changeVersion($("#descVersionFlag"));
			changeMainId($("#mainIdFlag"));
			changeAsvc($("#asvc"));
			changeType($("#descType"));
			break;
		case 122:
			$("#descEnhanced").prop("checked", true);
			for(i = 0; i < SEC_NUM_ENHANCE; i++)
			{
				sectionData = data[i].split(SECOND_DELIMITER);
				length = sectionData.length;
				for(j = 0; j < length; j++)
				{
					if((i == 0) && ((j == (length - 1)) || (j == (length - 2))))
					{
						$("#" + enhanceObjIdArray[i][j]).val(sectionData[j]);
					}
					else if((i == (SEC_NUM_ENHANCE - 1)) && (j == 0))
					{
						$("#" + enhanceObjIdArray[i][j]).val(sectionData[j]);
					}
					else if((i == 2) && (j != 0))
					{
						$("#" + enhanceObjIdArray[i][j]).val(sectionData[j]);
					}
					else if(((i == 3) || (i == 4) || (i == 5)) && ((j == 2) || (j == 3)))
					{
						$("#" + enhanceObjIdArray[i][j]).val(sectionData[j]);
					}
					else
					{
						if(parseInt(sectionData[j], 10) == CHECKED)
						{
							$("#" + enhanceObjIdArray[i][j]).prop("checked", true);
						}
						else
						{
							$("#" + enhanceObjIdArray[i][j]).prop("checked", false);
						}
						if((i == 2) && (j != 0))
						{
							changeFullService($("#fullService0"), 0);
						}
						else if(((i == 3) || (i == 4) || (i == 5)) && (j == 1))
						{
							changeFullService($("#fullService" + (i - 2)), (i - 2));
						}
					}
				}
			}
					
			changeEnhance($("#descEnhanced"));
			changeVersion($("#descVersionFlag"));
			changeMainId($("#mainIdFlag"));
			changeAsvc($("#asvc"));
			changeType($("#descType"));
			break;
		default:
			for(i = 0; i < OBJ_NUM; i++)
			{
				$("#" + objIdArray[i]).val(data[i]);
			}
			break;
	}
}

function descPageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	for(var i = 0; i < DESC_NUM; i++)
	{
		if(descTag == descTypeArray[i])
		{
			break;
		}
	}
	if(i == DESC_NUM)
	{
		descTag = 255;
	}
	
	if(descParamCheck() == false)
	{
		return;
	}
	
	data = "type=" + psiType + "&cmd=" + actionType + "&language=" + language + "&operation=" + operation + "&descId=" + descId + "&descTag=" + descTag + "&setString=";
	
	data += descGenerateData();

	xmlHttp.open("POST", "/goform/formIPQAM", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				self.location.reload(true);
			}
			else
			{
				alert(returnError[language][response]);
			}
		}
	}
	xmlHttp.send(data);
}

function descParamCheck()
{
	var returnFlag;
	
	switch(descTag)
	{
		case 2:
		case 3:
		case 6:
		case 10:
		case 73:
		case 98:
			break;
		case 65:		
		case 83:
		case 86:
		case 89:
		case 91:
		case 92:
		case 93:		
		case 131:
			if(rowNum == 0)
			{
				if(language == ENGLISH)
				{
					alert("The number of adding data can't be 0!");
				}
				else
				{
					alert("添加的行数不能为0！");
				}
				return false;
			}
			break;
		case 9:
			returnFlag = ValidateParam($("#caSystemId"), "INT_DEC_HEX", 1, 65535, "<CA System ID>", "<CA 系统ID>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#caPid"), "INT_DEC_HEX", 32, 8190, "<CA PID>", "<CA PID>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#privateData"), "INT_HEX_NULL", 0, 0, "<Private Data>", "<私有数据>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#privateData"), "LENGTH", 0, 502, "<Private Data>", "<私有数据>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 11:
			returnFlag = ValidateParam($("#accuracyInteger"), "INT_DEC", 0, 63, "<Clock Accuracy Integer>", "<时钟精确度整数>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#accuracyExponent"), "INT_DEC", 0, 7, "<Clock Accuracy Exponent>", "<时钟精确度指数>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 12:
			if($("#mdvValidFlag").prop("checked") == true)
			{
				returnFlag = ValidateParam($("#multiDelayVatiation"), "INT_DEC", 0, 32767, "<Multiplex Delay Variation>", "<复用延时变量>", language);
				if(returnFlag == false)
				{
					return false;
				}
			}
			break;
		case 14:
			returnFlag = ValidateParam($("#maxBitrate"), "INT_DEC", 0, 4194303, "<Maximum Bitrate>", "<最大比特率>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 15:
			returnFlag = ValidateParam($("#privateDataIndicator"), "INT_DEC_HEX", 0, 4294967295, "<Private Data Indicator>", "<私用数据指示器>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 16:
			returnFlag = ValidateParam($("#leakRate"), "INT_DEC", 0, 4194303, "<Leak Rate>", "<泄露码率>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#size"), "INT_DEC", 0, 4194303, "<Size>", "<长度>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 64:
			returnFlag = ValidateParam($("#networkName"), "LENGTH", 0, 31, "<Network Name>", "<网络名称>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#networkName"), language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 66:
			returnFlag = ValidateParam($("#stuffLength"), "INT_DEC_HEX", 1, 255, "<Stuffing Length>", "<填充长度>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#stuffByte"), "INT_HEX", 0, 0,"<Stuffing Bytes>", "<填充字节>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#stuffByte"), "LENGTH", 2, 2, "<Stuffing Bytes>", "<填充字节>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 67:
			returnFlag = ValidateParam($("#frequency"), "FLOATING", 0, 999.99999, "<Frequency>", "<频率>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#orbitalPosition"), "FLOATING", 0, 179.9, "<Orbital Position>", "<轨道位置>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#symbolrate"),"FLOATING", 0, 999.9999, "<Symbol Rate>", "<符号率>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 68:
			returnFlag = ValidateParam($("#frequency"), "FLOATING", 0, 9999.9999, "<Frequency>", "<频率>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#symbolrate"), "FLOATING", 0, 999.9999, "<Symbol Rate>", "<符号率>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 71:
			returnFlag = ValidateParam($("#bouquetName"), "LENGTH", 0, 31, "<Bouquet Name>", "<业务群名称>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#bouquetName"), language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 72:
			returnFlag = ValidateParam($("#descServiceName"), "LENGTH", 0, 31, "<Service Name>", "<业务名称>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#descServiceName"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#descProviderName"), "LENGTH", 0, 31, "<Provider Name>", "<业务提供商>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#descProviderName"), language);
			if(returnFlag == false)
			{
				return false;
			}
			if(parseInt($("#descServiceType").val(), 10) == CUSTOM)
			{
				returnFlag = ValidateParam($("#descCustomType"), "INT_DEC_HEX", 17, 255, "<Custom Type>", "<自定义类型>", language);
				if(returnFlag == false)
				{
					return false;
				}
			}
			break;
		case 74:
			returnFlag = ValidateParam($("#transStreamId"), "INT_DEC_HEX", 0, 65535, "<Transport Stream ID>", "<传送流ID>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#descOriginalNetId"), "INT_DEC_HEX", 0, 65535, "<Original Network ID>", "<原始网络ID>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#descServiceId"), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<节目号>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#privateData"),"INT_HEX_NULL", 0, 0, "<Private Data>", "<私有数据>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#privateData"), "LENGTH", 0, 496, "<Private Data>", "<私有数据>", language);
			if(returnFlag == false)
			{
				return false;
			}
			if(parseInt($("#descLinkType").val(), 10) == CUSTOM_LINK_TYPE)
			{
				returnFlag = ValidateParam($("#descCustomType"), "INT_DEC_HEX", 128, 254, "<Custom Type>", "<自定义类型>", language);
				if(returnFlag == false)
				{
					return false;
				}
				$("#descLinkType option[value=9]").val($("#descCustomType").val()); 
			}
			break;
		case 82:
			returnFlag = ValidateParam($("#componentTag"), "INT_DEC_HEX", 0, 255, "<Component Tag>", "<组件标签>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 87:
			returnFlag = ValidateParam($("#connectionType"), "INT_DEC_HEX", 0, 31, "<Connection Type>", "<连接类型>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#countryPrefixChar"), "LENGTH", 0, 3, "<Country Prefix>", "<国家前缀字符>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#countryPrefixChar"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#internationalAreaCodeChar"), "LENGTH", 0, 7, "<International Area Code>", "<国际区域代码字符>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#internationalAreaCodeChar"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#operatorCodeChar"), "LENGTH", 0, 3, "<Operator Code>", "<接线员代码字符>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#operatorCodeChar"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#nationalAreaCodeChar"), "LENGTH", 0, 7, "<National Area Code>", "<国内区域代码字符>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#nationalAreaCodeChar"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#coreNumberChar"), "LENGTH", 0, 15, "<Core Number>", "<中心号码字符>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#coreNumberChar"), language);
			if(returnFlag == false)
			{
				return false;
			}
			break;		
		case 90:
			returnFlag = ValidateParam($("#frequency"), "INT_DEC_HEX", 1, 4294967295, "<Centre Frequency>", "<中心频率>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 95:
			returnFlag = ValidateParam($("#privateDataSpecifier"), "INT_DEC_HEX", 0, 4294967295, "<Private Data Specifier>", "<专用数据说明符>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 100:
			returnFlag = ValidateParam($("#dataBroadcastId"), "INT_DEC_HEX", 1, 65535, "<Data Broadcast Identifier>", "<数据广播标识符>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#componentTag"), "INT_DEC_HEX", 0, 255, "<Component Tag>", "<组件标签>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#languageCode"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#selector"), "INT_HEX_NULL", 0, 0, "<Selector>", "<选数器>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#textChar"), language);
			if(returnFlag == false)
			{
				return false;
			}
			var tempselector = $("#selector").val();
			var temptextchar = $("#textChar").val();
			if(tempselector.length * 2 + temptextchar.length > 490)
			{
				alert("The length of descriptor cannot exceed 250!");
			}
			break;
		case 106:
		case 122:
			if($("#descVersionFlag").prop("checked") == true)
			{
				returnFlag = ValidateParam($("#descVersion"), "INT_DEC_HEX", 0, 31, "<AC-3 Version>", "<AC-3版本>", language);
				if(returnFlag == false)
				{
					return false;
				}
			}
			break;
		default:
			returnFlag = ValidateParam($("#customDescTag"), "INT_DEC_HEX", 0, 254, "<Descriptor Tag>", "<描述符标识>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#customDescData"), "INT_HEX", 0, 0, "<Descriptor Data>", "<描述符数据>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#customDescData"), "LENGTH", 0, 510, "<Descriptor Data>", "<描述符数据>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
	}
	return true;
}

function descGenerateData()
{
	var i;
	var j;
	var length;
	var sectionData;
	var data = "";
	var checkVal;
	var tempVal;
	
	switch(descTag)
	{
		case 2:
			for(i = 0; i < OBJ_NUM; i++)
			{
				if((i == 1) || (i == 5) || (i == 6) || (i == 7))
				{
					data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
				}
				else
				{
					if($("#" + objIdArray[i]).prop("checked") == true)
					{
						checkVal = CHECKED;
					}
					else
					{
						checkVal = NO_CHECKED;
					}
					if(i == 0)
					{
						data = checkVal;
					}
					else
					{
						data += FIRST_DELIMITER + checkVal;
					}
				}
			}
			break;

		case 3:
		case 11:
		case 12:
		case 87:
			for(i = 0; i < OBJ_NUM; i++)
			{
				if(i == 0)
				{
					if($("#" + objIdArray[i]).prop("checked") == true)
					{
						data = CHECKED;
					}
					else
					{
						data = NO_CHECKED;
					}
				}
				else
				{
					data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
				}
			}
			break;
		case 6:
			data = $("#" + objIdArray[elementType]).val();
			break;
		case 9:
		case 14:
		case 15:
		case 16:
		case 64:
		case 66:
		case 67:
		case 68:
		case 71:
		case 72:
		case 74:
		case 82:
		case 90:
		case 95:
		case 100:
			if(descTag == 67)
			{
				tempVal = parseFloat($("#" +  objIdArray[0]).val());
				$("#" + objIdArray[0]).val(tempVal.toFixed(5));
				tempVal = parseFloat($("#" +  objIdArray[1]).val());
				$("#" + objIdArray[1]).val(tempVal.toFixed(1));
				tempVal = parseFloat($("#" +  objIdArray[5]).val());
				$("#" + objIdArray[5]).val(tempVal.toFixed(4));
			}
			else if(descTag == 68)
			{
				tempVal = parseFloat($("#" +  objIdArray[0]).val());
				$("#" + objIdArray[0]).val(tempVal.toFixed(4));
				tempVal = parseFloat($("#" + objIdArray[3]).val());
				$("#" + objIdArray[3]).val(tempVal.toFixed(4));
			}
			for(i = 0; i < OBJ_NUM; i++)
			{
				if(i == 0)
				{
					data = $("#" + objIdArray[i]).val();
				}
				else
				{
					data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
				}
			}
			break;
		case 65:
		case 83:
		case 86:
		case 89:
		case 91:
		case 92:
		case 93:
		case 131:
			
			for(i = 0; i < rowNum; i++)
			{
				if(i == 0)
				{
					data = descData[i];
				}
				else
				{
					data += FIRST_DELIMITER +  descData[i];
				}
			}
			break;
		case 10:
		case 73:
		case 98:
			data = $("#" + firstId).val() + FIRST_DELIMITER;
			for(i = 0; i < rowNum; i++)
			{
				if(i == 0)
				{
					if(descTag == 98)
					{
						data += parseFloat(descData[i]) * 1000000;
					}
					else
					{
						data += descData[i];	
					}
				}
				else
				{
					if(descTag == 98)
					{
						data += SECOND_DELIMITER +  parseFloat(descData[i]) * 1000000;
					}
					else
					{
						data += SECOND_DELIMITER + descData[i];
					}
				}
			}
			break;
		case 106:
			for(i = 0; i < SEC_NUM_NORMAL; i++)
			{
				length = normalObjIdArray[i].length;
				for(j = 0; j < length; j++)
				{
					if((i == 0) && (j == 0))
					{
						if($("#" + normalObjIdArray[i][j]).prop("checked") == true)
						{
							data = CHECKED;
						}
						else
						{
							data = NO_CHECKED;
						}
					}
					else if((i != 0) && (j == 0))
					{
						if(i == (SEC_NUM_NORMAL - 1))
						{
							data += FIRST_DELIMITER + $("#" + normalObjIdArray[i][j]).val();
						}
						else
						{
							if($("#" + normalObjIdArray[i][j]).prop("checked") == true)
							{
								data += FIRST_DELIMITER + CHECKED;
							}
							else
							{
								data += FIRST_DELIMITER + NO_CHECKED;
							}
						}
					}
					else
					{
						if((i == 0) && ((j == (length - 1)) || (j == (length - 2))))
						{
							data += SECOND_DELIMITER + $("#" + normalObjIdArray[i][j]).val();
						}
						else if((i == 2) && (j != 0))
						{
							data += SECOND_DELIMITER + $("#" + normalObjIdArray[i][j]).val();
						}
						else
						{
							if($("#" + normalObjIdArray[i][j]).prop("checked") == true)
							{
								data += SECOND_DELIMITER + CHECKED;
							}
							else
							{
								data += SECOND_DELIMITER + NO_CHECKED;
							}
						}
					}
				}
			}
			break;
		case 122:
			for(i = 0; i < SEC_NUM_ENHANCE; i++)
			{
				length = enhanceObjIdArray[i].length;
				for(j = 0; j < length; j++)
				{
					if((i == 0) && (j == 0))
					{
						if($("#" + enhanceObjIdArray[i][j]).prop("checked") == true)
						{
							data = CHECKED;
						}
						else
						{
							data = NO_CHECKED;
						}
					}
					else if((i != 0) && (j == 0))
					{
						if(i == (SEC_NUM_ENHANCE - 1))
						{
							data += FIRST_DELIMITER + $("#" + enhanceObjIdArray[i][j]).val();
						}
						else
						{
							if($("#" + enhanceObjIdArray[i][j]).prop("checked") == true)
							{
								data += FIRST_DELIMITER + CHECKED;
							}
							else
							{
								data += FIRST_DELIMITER + NO_CHECKED;
							}
						}
					}
					else
					{
						if((i == 0) && ((j == (length - 1)) || (j == (length - 2))))
						{
							data += SECOND_DELIMITER + $("#" + enhanceObjIdArray[i][j]).val();
						}
						else if((i == 2) && (j != 0))
						{
							data += SECOND_DELIMITER + $("#" + enhanceObjIdArray[i][j]).val();
						}
						else if(((i == 3) || (i == 4) || (i == 5)) && ((j == 2) || (j == 3)))
						{
							data += SECOND_DELIMITER + $("#" + enhanceObjIdArray[i][j]).val();
						}
						else
						{
							if($("#" + enhanceObjIdArray[i][j]).prop("checked") == true)
							{
								data += SECOND_DELIMITER + CHECKED;
							}
							else
							{
								data += SECOND_DELIMITER + NO_CHECKED;
							}
						}
					}
				}
			}
			break;
		default:
			for(i = 0; i < OBJ_NUM; i++)
			{
				if(i == 0)
				{
					data = $("#" + objIdArray[i]).val();
				}
				else
				{
					data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
				}
			}
			break;
	}
	
	return data;
}

function updateTableData()
{
	var rowData;
	var index;
	var displayStrCn_131 = ["否", "是"];
	var displayStrEn_131 = ["No", "Yes"];
	var displayStr_131 = [displayStrEn_131, displayStrCn_131];
	
	var displayStrCn_65 = ["", "数字电视业务", "数字音频广播业务", "图文电视业务", "NVOD参考业务", "NVOD时移业务", "马赛克业务", "PAL制编码信号", "SECAM制编码信号", "D/D2-MAC", "调频广播", "NTSC制信号", "数据广播业务", "公共接口", "RCS 映射", "RCS FLS", "DVB MHP业务", "用户自定义"];
	var displayStrEn_65 = ["", "Digital Television", "Digital Audio Broadcast", "Teletext", "NVOD Reference", "NVOD Time-shifted", "Mosaic Service", "PAL Coding Signal", "SECAM Coding Signal", "D/D2-MAC", "Frequency Modulation", "NTSC Signal", "Data Broadcasting", "Common Interface", "RCS Map", "RCS FLS", "DVB MHPService", "Custom"];
	var displayStr_65 = [displayStrEn_65, displayStrCn_65];
	
	var displayStrCn_89 = ["", "图文字幕", "相关的图文", "VBI数据", "DVB字幕，无宽高比限制", "DVB字幕，宽高比为4:3", "DVB字幕，宽高比为16:9", "DVB字幕，宽高比2.21:1", "DVB字幕(听力障碍者)，无宽高比限制", "DVB字幕(听力障碍者)，宽高比为4:3", "DVB 字幕(听力障碍者)，宽高比为16:9", "DVB 字幕(听力障碍者)，宽高比2.21:1"];
	var displayStrEn_89 = ["", "EBU Teletext Subtitles", "Associated Teletext", "VBI Data", "DVB, No Aspect Ratio Limit", "DVB, 4:3 Aspect Ratio", "DVB, 16:9 Aspect Ratio", "DVB, 2.21:1 Aspect Ratio", "DVB(Hearing Impaired), No Aspect Ratio Limit", "DVB(Hearing Impaired), 4:3 Aspect Ratio", "DVB(Hearing Impaired),16:9 Aspect Ratio", "DVB(Hearing Impaired),2.21:1 Aspect Ratio"];
	var displayStr_89 = [displayStrEn_89, displayStrCn_89];
	
	var displayStrCn_86 = ["", "初始图文电视页面", "图文电视字幕页面", "附加信息页面", "节目时间表页面", "为听力损伤的人的图副题记录"];
	var displayStrEn_86 = ["", "Initial Teletext Page", "Teletext Title Page", "Additional Info Page", "Service Schedule Page", "Teletext Subtitle For Hearing Impaired"];
	var displayStr_86 = [displayStrEn_86, displayStrCn_86];

	for(var i = 0; i < rowNum; i++)
	{
		index = i + 1;
		rowData = descData[i].split(SECOND_DELIMITER);
		for(var j = 0; j < COL_NUM; j++)
		{
			if((descTag == 131) && (j == 2))
			{
				$("#" + objIdArray[j] + index).html(displayStr_131[language][parseInt(rowData[j], 10)]);
			}
			else if((descTag == 89) && (j == 1))
			{
				$("#" + objIdArray[j] + index).html(displayStr_89[language][parseInt(rowData[j], 10)]);
			}
			else if((descTag == 86) && (j == 1))
			{
				$("#" + objIdArray[j] + index).html(displayStr_86[language][parseInt(rowData[j], 10)]);
			}
			else if(descTag == 65)
			{
				if(j == 1)
				{
					$("#" + objIdArray[j] + index).html(displayStr_65[language][parseInt(rowData[j], 10)]);
				}
				else if(j == 2)
				{
					if(parseInt(rowData[1], 10) == CUSTOM)
					{
						$("#" + objIdArray[j] + index).html(rowData[j]);
					}
					else
					{
						$("#" + objIdArray[j] + index).html("--");
					}
				}
				else
				{
					$("#" + objIdArray[j] + index).html(rowData[j]);
				}
			}
			else
			{
				$("#" + objIdArray[j] + index).html(rowData[j]);
			}
		}
	}
}

function validateBeforeAdd()
{
	var returnFlag;
	var rowData;
	
	if(rowNum == maxRowNum)
	{
		if(language == ENGLISH)
		{
			alert("The adding number of data is no more than " + maxRowNum + "!");
		}
		else
		{
			alert("最多允许添加" + maxRowNum + "行数据！");
		}
		return false;
	}
	switch(descTag)
	{
		case 10:
			returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#languageCode"), language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 65:
			returnFlag = ValidateParam($("#descServiceId"), "INT_DEC_HEX", 1, 65535, "<Service ID>", "<节目号>", language);
			if(returnFlag == false)
			{
				return false;
			}
			if(parseInt($("#descServiceType").val(), 10) == CUSTOM)
			{
				returnFlag = ValidateParam($("#descCustomType"), "INT_DEC", 17, 255, "<Custom Type>", "<自定义类型>", language);
				if(returnFlag == false)
				{
					return false;
				}
			}
			break;
		case 73:
			returnFlag = ValidateParam($("#countryCode"), "LENGTH", 3, 3, "<Country Code>", "<国家代码>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#countryCode"), language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 83:
			returnFlag = ValidateParam($("#caSystemId"), "INT_DEC_HEX", 1, 65535, "<CA System ID>", "<CA系统标识符>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 86:
			returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#languageCode"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#ttMagazineNum"), "INT_DEC_HEX", 0, 7, "<Teletext Magazine Number>", "<图文杂志号>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#ttPageNum"), "INT_DEC_HEX", 0, 255, "<Teletext Page Number>", "<图文页面号>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 89:
			returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#languageCode"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#compPageId"), "INT_DEC_HEX", 0, 65535, "<Composition Page ID>", "<构图页面标识>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#ancilPageId"), "INT_DEC_HEX", 0, 65535, "<Ancillary Page ID>", "<辅助页面标识>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 91:
			returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#languageCode"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#networkName"), "LENGTH", 0, 31, "<Network Name>", "<网络名称>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#networkName"), language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 92:
			returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#languageCode"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#bouquetName"), "LENGTH", 0, 31, "<Bouquet Name>", "<群名称>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#bouquetName"), language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 93:
			returnFlag = ValidateParam($("#languageCode"), "LENGTH", 3, 3, "<Language Code>", "<语言代码>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#languageCode"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#descServiceProvider"), "LENGTH", 0, 31, "<Service Provider Name>", "<业务提供商>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#descServiceProvider"), language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#descServiceName"), "LENGTH", 0, 31, "<Service Name>", "<业务名称>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateName($("#descServiceName"), language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 98:
			var codingType = parseInt($("#codingType").val(), 10);
			var minCenterFreq = [0, 0, 0, 1];
			var maxCenterFreq = [4294.967295, 999999.99, 9999.9999, 42949.67295];
			returnFlag = ValidateParam($("#centerFreq"), "FLOATING", minCenterFreq[codingType], maxCenterFreq[codingType], "<Centre Frequency>", "<中心频率>", language);
			if(returnFlag == false)
			{
				return false;
			}
			break;
		case 131:
			returnFlag = ValidateParam($("#descServiceId"), "INT_DEC", 1, 65535, "<Service ID>", "<节目号>", language);
			if(returnFlag == false)
			{
				return false;
			}
			returnFlag = ValidateParam($("#logicChNum"), "INT_DEC", 0, 1023, "<Logical Channel Number>", "<逻辑频道号>", language);
			if(returnFlag == false)
			{
				return false;
			}
			for(var i = 0; i < rowNum; i++)
			{
				rowData = descData[i].split(SECOND_DELIMITER);
				if(parseInt($("#descServiceId").val(), 10) == parseInt(rowData[0], 10))
				{
					if(language == ENGLISH)
					{
						alert("Service ID is repeated!");
					}
					else
					{
						alert("节目号重复!");
					}
					return false;
				}
				if(parseInt($("#logicChNum").val(), 10) == parseInt(rowData[1], 10))
				{
					if(language == ENGLISH)
					{
						alert("Logical Channel Number is repeated!");
					}
					else
					{
						alert("逻辑频道号重复!");
					}
					return false;
				}
			}
			break;
		default:
			break;
	}
}

var SELECT_PARAM = 1;
var LCN_SELECT_PARAM = 2;
var DEFAULT_SELECT_INDEX = 0;

function clearParamValue()
{
	switch(descTag)
	{
		case 10:
		case 73:
		case 83:
		case 91:
		case 92:
		case 93:
		case 98:
			for(var i = 0; i < COL_NUM; i++)
			{
				$("#" + objIdArray[i]).val("");
			}
			if((descTag == 98) && (rowNum != 0))
			{
				$("#codingType").attr("disabled", true);
			}
			break;
		case 65:
		case 86:
		case 89:
			for(var i = 0; i < COL_NUM; i++)
			{
				if(i == SELECT_PARAM)
				{
					$("#" + objIdArray[i]).get(0).selectedIndex = DEFAULT_SELECT_INDEX;
				}
				else
				{
					$("#" + objIdArray[i]).val("");
				}				
			}
			if(descTag == 65)
			{
				$("#descCustomTypeTr").css("display", "none");
				if(serviceListCustomFlag == true)
				{
					$("#simplemodal-container").css("height", function(index, value)
						{
							height = $(this).height();
							return ((height - ROW_HEIGHT) + "px");
						});
					serviceListCustomFlag = false;
				}
			}
			break;
		case 131:
			for(var i = 0; i < COL_NUM; i++)
			{
				if(i == LCN_SELECT_PARAM)
				{
					$("#" + objIdArray[i]).get(0).selectedIndex = DEFAULT_SELECT_INDEX;
				}
				else
				{
					$("#" + objIdArray[i]).val("");
				}				
			}
			break;
		default:
			break;
	}
	
}

var addNum = 0;
var origHeight;
var ROW_HEIGHT = 22;
var DISPLAY_ROW_NUM = 5;
var HEIGHT_OFFSET = ROW_HEIGHT * DISPLAY_ROW_NUM;
function addTableRow()
{
	var rowData;
	var height;
	
	if(validateBeforeAdd() == false)
	{
		return;
	}
	
	for(var i = 0; i < COL_NUM; i++)
	{
		if(i == 0)
		{
			if(descTag == 98)
			{
				rowData = parseFloat($("#" + objIdArray[i]).val()).toFixed(6);
			}
			else
			{
				rowData = $("#" + objIdArray[i]).val();
			}
		}
		else
		{
			rowData += SECOND_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}
	
	descData.push(rowData);
	rowNum++;
	clearParamValue();
	AddRow("dataTable", "dataRow", "CaseRow");
	updateTableData();
	
	$("#simplemodal-container").css("height", function(index, value)
	{
		height = $(this).height();
		if(addNum == 0)
		{
			origHeight = height;
		}
		if(height >= (origHeight + HEIGHT_OFFSET))
		{
			return ((origHeight + HEIGHT_OFFSET) + "px");
		}
		else
		{
			return ((height + ROW_HEIGHT) + "px");
		}
	});
	addNum++;
}

function deleteCurrentRow(obj)//delete row
{
	var height;
	var infoHeight;
	var index = parseInt(obj.attr("id").slice(6)) - 1;
	
	descData.splice(index, 1);
	rowNum--;
	if((descTag == 98) && (rowNum == 0))
	{
		$("#codingType").attr("disabled", false);
	}
	DelRow("dataTable", "dataRow", "CaseRow");
	updateTableData();
	infoHeight = ($("#descInfo").height() + 44);
	
	$("#simplemodal-container").css("height", function(index, value)
	{
		height = $(this).height();
		if(infoHeight >= height)
		{
			return ((origHeight + HEIGHT_OFFSET) + "px");
		}
		else
		{
			if(height <= origHeight)
			{
				return (origHeight + "px");
			}
			else
			{
				return ((height - ROW_HEIGHT) + "px");
			}
		}
	});
}